/**********************************************************************
 Copyright (c), 1991-2007, T&W ELECTRONICS(SHENTHEN) Co., Ltd.
 ļ : pc_api.h
 ļ : pcģṩapiӿͷļ
 б :

 ޶¼ :
          1  : Ծ
             : 2007-11-15
             :

**********************************************************************/

#ifndef __PC_API_H__
#define __PC_API_H__

#include <signal.h>
#include "tbstype.h"
#include "tbsmsg.h"
#include "tbserror.h"

#ifdef _cplusplus
    #if _cplusplus
        extern "C" {
    #endif
#endif

#define _PC_VER_R1

/* źֵ */
#define TBS_SIGSTART  (unsigned char)0
#define TBS_SIGHUP    (unsigned char)SIGHUP
#define TBS_SIGINT    (unsigned char)SIGINT
#define TBS_SIGQUIT   (unsigned char)SIGQUIT
#define TBS_SIGILL    (unsigned char)SIGILL
#define TBS_SIGTRAP   (unsigned char)SIGTRAP
#define TBS_SIGABRT   (unsigned char)SIGABRT
#define TBS_SIGEMT    (unsigned char)SIGEMT
#define TBS_SIGFPE    (unsigned char)SIGFPE
#define TBS_SIGKILL   (unsigned char)SIGKILL
#define TBS_SIGBUS    (unsigned char)SIGBUS
#define TBS_SIGSEGV   (unsigned char)SIGSEGV
#define TBS_SIGSYS    (unsigned char)SIGSYS
#define TBS_SIGPIPE   (unsigned char)SIGPIPE
#define TBS_SIGALRM   (unsigned char)SIGALRM
#define TBS_SIGTERM   (unsigned char)SIGTERM
#define TBS_SIGURG    (unsigned char)SIGURG
#define TBS_SIGSTOP   (unsigned char)SIGSTOP
#define TBS_SIGTSTP   (unsigned char)SIGTSTP
#define TBS_SIGCONT   (unsigned char)SIGCONT
#define TBS_SIGCHLD   (unsigned char)SIGCHLD
#define TBS_SIGTTIN   (unsigned char)SIGTTIN
#define TBS_SIGTTOU   (unsigned char)SIGTTOU
#define TBS_SIGIO     (unsigned char)SIGIO
#define TBS_SIGXCPU   (unsigned char)SIGXCPU
#define TBS_SIGXFSZ   (unsigned char)SIGXFSZ
#define TBS_SIGVTALRM (unsigned char)SIGVTALRM
#define TBS_SIGPROF   (unsigned char)SIGPROF
#define TBS_SIGWINCH  (unsigned char)SIGWINCH
#define TBS_SIGINFO   (unsigned char)SIGINFO
#define TBS_SIGUSR1   (unsigned char)SIGUSR1
#define TBS_SIGUSR2   (unsigned char)SIGUSR2

#define TBS_SIGNULL   (unsigned char)(0xff)

#define PC_IS_KILL_SIG(sig) (TBS_SIGKILL == (sig) || TBS_SIGTERM == (sig))


/* ʱ: ֲ */
#define PC_NO_CHANGE           0xff




/* pcӿڷֵͶ */
typedef int   PC_RET;


#define PC_OK             TBS_SUCCESS
#define PC_FAIL           TBS_FAILED

#define ERR_PC_PARA       ERR_PARA_INVALID
#define ERR_PC_MALLOC     ERR_MALLOC_FAILED



/* ģṩĽ̲ӿڵ */
typedef int (*FUNC_PROC_CTRL)(const char *pcName, unsigned long ulInstNo,
                              unsigned char ucProcOpt);

/* ״̬״̬,
   ģһֻע PC_STATE_STOPPED  PC_STATE_STARTED */
enum
{
    PC_STATE_NULL,

    PC_STATE_STOPPED,
    PC_STATE_WAIT_START,
    PC_STATE_STARTED,
    PC_STATE_WAIT_STOP,
    PC_STATE_RESTART
};


/* ״̬¼,
PC_EVENT_RESTART  PC_EVENT_STOP ģ鷢
¼ͨpcϢ
*/
enum
{
   PC_EVENT_NULL,

   PC_EVENT_RESTART,
   PC_EVENT_STOP,

   PC_EVENT_START_OK,
   PC_EVENT_START_FAIL,

   PC_EVENT_STOP_OPT_OK,
   PC_EVENT_STOP_OPT_FAIL,

   PC_EVENT_RESTART_OPT_OK,
   PC_EVENT_RESTART_OPT_FAIL,

   PC_EVENT_RESTART_OK,
   PC_EVENT_RESTART_FAIL,

   PC_EVENT_EXIT
};

/* ģṩĽ̽ӿڵֲʽ */
enum
{
    PC_OPT_NULL,

    PC_OPT_START,
    PC_OPT_STOP,
    PC_OPT_RESTART
};




#define PC_PROC_NAME_LEN   16

/*   ̵Ĳṹ */
typedef struct
{
    char acName[PC_PROC_NAME_LEN]; /*  */
    unsigned long ulInstNo;        /* ʵ */

    unsigned char ucSignal;        /* źֵ, ΪTBS_SIGSTART ʱ
                                      ʾһ */
    unsigned char ucNeedRestart;   /* ʱ, ʾ˳Ƿ */
    unsigned char  ucNeedSteady;   /* ǷҪ־û */
    unsigned char  ucExecCount;    /* ִļͲ , ʱ,
                                      Ϊ0xff,ʾԭ */
    char **ppcExecInfo;            /* ִϢ */
    unsigned char  ucMonCount;     /* , ʱ,Ϊ0xff,
                                      ʾԭ */
    unsigned char  aucSpace[3];    /* ֽڶ */
    char **ppcMonVals;             /*  */

} ST_PC_PROC_CTRL_INFO;


/* PCϢʽ */
typedef struct
{
    char acName[PC_PROC_NAME_LEN];
    unsigned long ulInstNo;
    unsigned char ucSignal;
    unsigned char ucNeedRestart;
    unsigned char ucNeedSteady;
    unsigned char ucExecCount;
    /* unsigned char ucMonCount; */

} ST_PC_PROC_CTRL_MSG;


/* pcӦϢʽ */
typedef struct
{
    char acName[PC_PROC_NAME_LEN];
    unsigned long ulInstNo;
    unsigned char ucSignal;
    unsigned char ucNeedRestart;
    unsigned char aucSpace[2];
    unsigned long ulRet;

} ST_PC_REPLY_MSG;


/* pc̱״̬Ϣʽ */
/*lint -save -e46*/
typedef struct
{
    char acName[PC_PROC_NAME_LEN];
    unsigned long ulInstNo;

    unsigned char ucProcState;
    unsigned char ucExitSignal;
    unsigned char ucLastSignal;
    unsigned char ucNeedSteady : 4;
    unsigned char ucWillRestart : 4;

    unsigned long ulRestartRet;

} ST_PC_STATE_MSG;
/*lint -restore*/


/* ʵṹ */
typedef struct tag_ST_PC_PROC_INST
{
    struct tag_ST_PC_PROC_INST *pstNext;

    char acName[PC_PROC_NAME_LEN];
    unsigned long  ulInstNo;
    unsigned char  ucState;
    unsigned char  aucSpace[3];

} ST_PC_PROC_INST;



#define PC_PROC_ID_LEN  (PC_PROC_NAME_LEN + sizeof(unsigned long))


/* ̷ź */
PC_RET PC_ProcCtrl(unsigned short usMID,
                            const ST_PC_PROC_CTRL_INFO *pstProcCtrlInfo);

/* ״̬ */
PC_RET PC_StateMachine(const ST_MSG *pstPcMsg,
                    const char *pcName, unsigned long ulInstNo,
                    FUNC_PROC_CTRL pfnProcCtrl, unsigned char ucEvent,
                    unsigned char *pucState);

/* ȡ̵ǰ״̬ */
PC_RET PC_GetProcInstState(const char *pcName, unsigned long ulInstNo,
                           unsigned char *pucState);

/* ӡϢ */
void PC_PrintExecInfo(char *apszExecInfo[], int iExecInfoLen);


#ifdef _PC_VER_R1

/* id */
#define PC_MAX_PROC_ID         0xfe


/*   ̵Ĳṹ */
typedef struct
{
    unsigned long  ulMsgID;
    unsigned short usMID;          /* ģid */
    unsigned char  ucNeedSteady;   /* ǷҪ־û */
    unsigned char  ucExecCount;    /* ִļͲ , ʱ,
                                      Ϊ0xff,ʾԭ */
    char **ppcExecInfo;            /* ִϢ */
    unsigned char  ucMonCount;     /* , ʱ,Ϊ0xff,
                                      ʾԭ */
    unsigned char  aucSpace[3];    /* ֽڶ */
    char **ppcMonVals;             /*  */

} ST_PC_PROC_START;



/*************************************************************************
Function:      PC_RET PC_StartProcess(const ST_PC_PROC_START *pstStartInfo)
Description:   ͨPC̵API
Calls:         MSG_SendMessage
Data Accessed:
Data Updated:
Input:         pstStartInfo, ṹ, οṹ崦ע
Output:        
Return:        0,ɹ;
               , ʧ
Others:
*************************************************************************/
PC_RET PC_StartProcess(const ST_PC_PROC_START *pstStartInfo);

/*************************************************************************
Function:      PC_RET PC_SendProcessSignal(unsigned long ulProcID,
                     unsigned char ucSignal, unsigned char ucNeedReatart,
                     const ST_PC_PROC_START *pstStartInfo)
Description:   ̷ź
Calls:
Data Accessed:
Data Updated:
Input:         ulProcID, ҪʵProcID
               ucSignal, źֵ
               ucNeedReatart, ǷҪ
               pstStartInfo, ṹ, οṹ崦ע
Output:        
Return:        0,ɹ;
               , ʧ
Others:
*************************************************************************/
PC_RET PC_SendProcessSignal(unsigned long ulProcID, unsigned char ucSignal,
        unsigned char ucNeedReatart, const ST_PC_PROC_START *pstStartInfo);



#endif









#ifdef _cplusplus
    #if _cplusplus
        }
    #endif
#endif


#endif /* __PC_API_H__ */
